// Base URL for the Exchange Rate API (replace API key if needed)
const URL = "https://v6.exchangerate-api.com/v6/${Enter Your API Key}/pair";

// Selecting elements from the DOM
let dropDown = document.querySelectorAll(".drop-down select");
let amount = document.querySelector(".amount input");
let btn = document.querySelector("button");
let fromCurr = document.querySelector(".from select");
let toCurr = document.querySelector(".to select");
let exchangedCurr = document.querySelector(".msg_box");

// Loop through both 'from' and 'to' dropdowns to populate currency options
for (let select of dropDown) {
  for (currCode in countryList) {
    // Create a new option tag for each currency
    let newOption = document.createElement("option");
    newOption.innerText = currCode;
    newOption.value = currCode;

    // Set default selected options (USD for 'from', INR for 'to')
    if (select.name === "from" && currCode === "USD") {
      newOption.selected = "selected";
    } else if (select.name === "to" && currCode === "INR") {
      newOption.selected = "selected";
    }

    // Append option to dropdown
    select.append(newOption);
  }

  // Add event listener to update flag when dropdown value changes
  select.addEventListener("change", (e) => {
    updateFlag(e.target);
  });

  // Function to update the flag icon based on selected currency
  const updateFlag = (element) => {
    let currCode = element.value; // selected currency code
    let countryCode = countryList[currCode]; // get country code from countryList

    // Set the flag image source dynamically
    let newSrc = `https://flagsapi.com/${countryCode}/flat/64.png`;
    let img = element.parentElement.querySelector("img");
    img.src = newSrc;
  };
}

// Event listener for the "Convert" button
btn.addEventListener("click", async (event) => {
  event.preventDefault();

  let amountValue = amount.value;
  if (amountValue === "" || amountValue < 1) {
    amountValue = 1;
    amount.value = "1";
  }

  exchangedCurr.innerHTML = "Fetching rate...";

  try {
    const Ex_URL = `${URL}/${fromCurr.value}/${toCurr.value}`;
    let response = await fetch(Ex_URL);
    let data = await response.json();

    exchangedCurr.innerHTML = `
      <div class="result-text">
          ${amount.value} ${data.base_code} = 
          ${Math.round(data.conversion_rate * amount.value)} ${data.target_code}
      </div>
    `;
  } catch (error) {
    exchangedCurr.innerHTML = "Something went wrong. Please try again.";
  }
});
